<?php


namespace Cms\Seo;

use POM\DomainObjectAbstract;

/**
 * Class TitleBuilder
 * @package Cms\Seo
 */
class TitleBuilder extends AbstractSeoBuilder
{

    /** @var string */
    public static $SUFFIX = '';

    /**
     * @var string
     */
    protected $title;

    /**
     * TitleBuilder constructor.
     * @param string $title
     */
    public function __construct($title = '')
    {
        $this->title = $title;
    }

    /**
     * @param string $str
     * @param string $glue
     * @return $this
     */
    public function mergeString($str, $glue = ' - ')
    {
        if (!empty($this->title)) {
            $this->title .= $glue;
        }
        $this->title .= $str;
        return $this;
    }

    /**
     * @param DomainObjectAbstract $model
     * @param string $attrName
     * @return $this
     */
    public function fallbackWithModel(DomainObjectAbstract $model, $attrName = 'seo_title')
    {
        $this->fallbackWithString($model[$attrName] ?? '');
        return $this;
    }

    /**
     * @param string $fallbackTitle
     * @return $this
     */
    public function fallbackWithString($fallbackTitle)
    {
        if (empty($fallbackTitle)) {
            $fallbackTitle = '';
        }
        $this->title = $this->title ?: $fallbackTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function render() : string
    {
        return $this->title . self::$SUFFIX;
    }
}
