<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedFactory;
use Move\Embed\EmbedModel;
use Move\Embed\Normalizer\NormalizerInterface;
use Move\Http\Middleware\BodyParser;

/**
 * Class Digiteka
 * @package Embed\Adapter
 */
class Digiteka implements AdapterInterface
{

    /** @var \Move\Embed\Normalizer\NormalizerInterface|null */
    private $normalizer;

    /**
     * @param \Move\Embed\Normalizer\NormalizerInterface|null $normalizer
     * @throws \InvalidArgumentException
     */
    public function __construct(NormalizerInterface $normalizer = null)
    {
        $this->normalizer = $normalizer;
    }

    /**
     * Renvoi les données de la source sous forme de model
     * @param string $sourceUri
     * @param array $params
     * @return EmbedModel
     * @throws \ReflectionException
     */
    public function getEmbedModel($sourceUri, array $params = [])
    {
        $requestUri = $sourceUri;
        if ($this->normalizer !== null) {
            $requestUri = $this->normalizer->normalizeStr($sourceUri);
        }
        $content = $this->call($requestUri);
        if (!empty($content['results'])
            && \is_array($content['results'])
            && !empty($content['results']['iframe'])
        ) {
            $imageUrl = $content['results']['image'] ?? null;
            if ($imageUrl) {
                $imageUrl = str_replace('http://', 'https://', $imageUrl);
            }
            $iframeSrc = str_replace('http://', 'https://', $content['results']['iframe']);
            return new EmbedModel([
                'title' => $content['results']['title'] ?? null,
                'provider_name' => 'Digiteka',
                'provider_url' => 'http://ultimedia.com',
                'author_name' => $content['results']['label'] ?? null,
                'html' => $iframeSrc,
                'thumbnail_url' => $imageUrl,
                'canonical_url' => $sourceUri,
                'source_url' => $sourceUri,
            ], $content['results']);
        }
        return null;
    }

    /**
     * @param string $requestUri
     * @return array|null
     */
    protected function call(string $requestUri)
    {
        try {
            $client = EmbedFactory::createClient('www.ultimedia.com');
            $results = $client->request('GET', [$requestUri]);
            $resultParsed = (new BodyParser())->parseMessage($results);
            return $resultParsed;
        } catch (\Exception $e) {
            trigger_error((string)$e, E_USER_WARNING);
        }
        return null;
    }
}
