<?php

namespace Move\Command;

use League\Tactician\CommandBus;
use PHPUnit\Framework\TestCase;

/**
 * Class TactitianBusAdapterTest
 * @package Move\Command
 */
class TactitianBusAdapterTest extends TestCase
{
    private $expected = 'expected result';

    /**
     * @covers TacticianBusAdapter::_construct
     * @return TactitianBusAdapter
     */
    public function testConstruct() {
        /** @var CommandBus|\PHPUnit_Framework_MockObject_MockObject $command */
        $command = $this
            ->getMockBuilder(CommandBus::class)
            ->setConstructorArgs([[]])
            ->setMethods(['handle'])
            ->getMock();

        $command
            ->expects($this->any())
            ->method('handle')
            ->willReturn($this->expected);

        $instance = new TactitianBusAdapter($command);
        $this->assertInstanceOf(TactitianBusAdapter::class, $instance);

        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers TacticianBusAdapter::handle
     * @param TactitianBusAdapter $instance
     */
    public function testHandle($instance) {
        $this->assertEquals($this->expected, $instance->handle(null));
    }
}
