<?php

namespace Move\Http\Strategy\Serializer;

use org\bovigo\vfs\vfsStream;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;

/**
 * Class JsonSerializerTest
 * @package Move\Http\Strategy\Serializer
 */
class JsonSerializerTest extends TestCase
{
    protected $dataset;
    protected $expectedResult;
    protected $responseInterface;
    protected $serializer;

    /**
     * @inheritdoc
     */
    protected function setUp()
    {
        $this->dataset = ['dummy' => 'data', 'key' => 'value'];
        $this->expectedResult = '{"dummy":"data","key":"value"}';

        $this->serializer = new JsonSerializer();
        $this->responseInterface = $this->getMockBuilder(ResponseInterface::class)
            ->getMock();
    }

    /**
     * @covers JsonSerializer::serialize
     */
    public function testSerialize()
    {
        $serialized = $this->serializer
            ->serialize(
                $this->dataset,
                $this->responseInterface
            );

        $this->assertEquals($this->expectedResult, $serialized);
    }

    /**
     * @covers JsonSerializer::serialize
     * @expectedException \InvalidArgumentException
     */
    public function testSerializeThrowsException()
    {
        vfsStream::setup('root');
        vfsStream::create(
            [
                'file.txt' => '',
            ]
        );
        $dir = vfsStream::url('root/file.txt');

        $dataset = fopen($dir, 'r+');
        $this->serializer
            ->serialize(
                $dataset,
                $this->responseInterface
            );
    }

    /**
     * @covers JsonSerializer::__invoke
     * @depends testSerialize
     */
    public function testInvoke()
    {
        $serialized = call_user_func(
            $this->serializer,
            $this->dataset,
            $this->responseInterface
        );

        $this->assertEquals($this->expectedResult, $serialized);
    }
}
