<?php

namespace Cms\Client\Article;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Article\LinkResource\LinkResourceModel;

/**
 * Class LinkResourceClient
 * @package Cms\Client\Article
 */
class LinkResourceClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'article/link-resource';

    /**
     * @param array $dataset
     * @return LinkResourceModel
     */
    public function handleData($dataset = [])
    {
        $model = (new LinkResourceModel())->populate($dataset);
        return $model;
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|LinkResourceModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $scopeId
     * @param string $linkType
     * @return LinkResourceModel[]|CmsApiIndexIterator|null
     */
    public function getIndexMostUsed($scopeId, $linkType)
    {
        $results = $this->getBuilder()
            ->setSortCol('most_used', 'ASC')
            ->setFilter('type', $linkType)
            ->setFilter('scope', $scopeId)
            ->getIndex(-1);
        return $results;
    }

    /**
     * @param int $articleCatId
     * @param string $linkType
     * @return LinkResourceModel[]|CmsApiIndexIterator|null
     */
    public function getIndexMostUsedByCategory($articleCatId, $linkType)
    {
        $results = $this->getBuilder()
            ->setSortCol('most_used', 'ASC')
            ->setFilter('type', $linkType)
            ->setFilter('article_cat_id', $articleCatId)
            ->getIndex(-1);
        return $results;
    }

    /**
     * @param int $scopeId
     * @param string $linkType
     * @param string|null $articleProfil
     * @return CmsApiIndexIterator|LinkResourceModel[]|null
     */
    public function getIndexDistinctRef($scopeId, $linkType, $articleProfil = null)
    {
        $results = $this->getBuilder()
            ->setFilter('type', $linkType)
            ->setFilter('scope', $scopeId)
            ->setFilter('article_profil', $articleProfil)
            ->getIndex(-1);
        return $results;
    }

    /**
     * @param int $articleCatId
     * @param string $linkType
     * @param string|null $articleProfil
     * @return CmsApiIndexIterator|LinkResourceModel[]|null
     */
    public function getIndexDistinctRefByCategory($articleCatId, $linkType, $articleProfil)
    {
        $results = $this->getBuilder()
            ->setFilter('type', $linkType)
            ->setFilter('article_cat_id', $articleCatId)
            ->setFilter('article_profil', $articleProfil)
            ->getIndex(-1);
        return $results;
    }
}
