<?php

namespace Cms\Worker\Scheduler;

use Cms\ConfigFactory;
use Cms\Worker\Command\Scheduler\SchedulerCommand;
use PhpAmqpLib\Connection\AMQPStreamConnection;

/**
 * Class SchedulerRabbitMQCommandHandler
 * @package Cms\Worker\Scheduler
 */
class SchedulerRabbitMQCommandHandler extends AbstractSchedulerCommandHandler
{
    /**
     * @throws \PhpAmqpLib\Exception\AMQPOutOfBoundsException
     * @throws \PhpAmqpLib\Exception\AMQPRuntimeException
     * @throws \UnexpectedValueException
     * @throws \InvalidArgumentException
     * @throws \LogicException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \RuntimeException
     * @throws \League\Flysystem\FileNotFoundException
     * @throws \Psr\Cache\InvalidArgumentException
     */
    public function handle(SchedulerCommand $command)
    {
        $config = ConfigFactory::createConfig('joggingCalendar');

        $connection = new AMQPStreamConnection(
            $config['rabbitmq.host'],
            $config['rabbitmq.port'],
            $config['rabbitmq.user'],
            $config['rabbitmq.password'],
            $config['rabbitmq.vhost']
        );
        $channel = $connection->channel();

        $scopeIds = (array)$command->getScopeId();
        $channel->queue_declare('task_queue', false, true, false, false);

        $callback = function ($msg) use ($channel, $scopeIds) {
            $task = $this->taskClient->getItem($msg->body);
            if ($task && \in_array($task->scope_id, $scopeIds)) {
                $result = $this->run($task);
                if ($result) {
                    $this->execTask($task);
                }
                $channel->basic_ack($msg->delivery_info['delivery_tag']);
            }
        };

        $channel->basic_qos(null, 1, null);
        $channel->basic_consume('task_queue', '', false, false, false, false, $callback);

        while (count($channel->callbacks)) {
            $channel->wait();
        }

        $channel->close();
        $connection->close();
    }
}
