<?php

namespace Move\Command\Command;

/**
 * Class CreateCommand
 * @package Move\Command\Command
 */
class CreateCommand implements DryRunCommandInterface
{
    use DryRunCommandTrait;

    /** @var array */
    protected $dataset;

    /**
     * CreateCommand constructor.
     * @param array $dataset
     */
    public function __construct(array $dataset)
    {
        $this->dataset = $dataset;
    }

    /**
     * @return array
     */
    public function getDataset() : array
    {
        return $this->dataset;
    }

    /**
     * @param array $dataset
     * @return CreateCommand
     */
    public function withDataset(array $dataset) : CreateCommand
    {
        $clone = clone $this;
        $clone->dataset = $dataset;
        return $clone;
    }
}
