<?php


namespace Move\Command\Command;

/**
 * Trait DryRunCommandTrait
 * @package Move\Command\Command
 */
trait DryRunCommandTrait
{

    /** @var  bool */
    protected $dryRun = false;

    /**
     * @return bool
     */
    public function isDryRun() : bool
    {
        return $this->dryRun;
    }

    /**
     * @param bool $dryRun
     * @return static
     */
    public function withDryRun(bool $dryRun)
    {
        $clone = clone $this;
        $clone->dryRun = $dryRun;
        return $clone;
    }
}
