<?php

namespace Cms\Client\Command;

use Move\Command\Exception\NotFoundException;
use Move\Http\Client\Exception\HttpRequestException;

/**
 * Interface ExceptionDecoratorInterface
 * @package Cms\Client\Command
 */
interface ExceptionDecoratorInterface
{

    /**
     * Permet d'attraper et de traiter les exceptions envoyé par les CommandHandler
     * On attend que l'exception soit lancée tout simplement, ou qu'une fonction
     * soit renvoyé en contrepartie
     * ```
     * throw $exception
     * ```
     * or
     * ```
     * return function ($request, $response) use ($exception) {
     *      return $response;
     * }
     * ```
     *
     * @param \Move\Command\Exception\NotFoundException $exception
     * @return callable
     */
    public function getNotFoundDecorator(NotFoundException $exception) : callable;


    /**
     * Permet d'attraper et de traiter les exceptions envoyé par les CommandHandler
     * On attend que l'exception soit lancée tout simplement, ou qu'une fonction
     * soit renvoyé en contrepartie
     * ```
     * throw $exception
     * ```
     * or
     * ```
     * return function ($request, $response) use ($exception) {
     *      return $response;
     * }
     * ```
     *
     * @param \Move\Http\Client\Exception\HttpRequestException $exception
     * @return callable
     */
    public function getHttpRequestDecorator(HttpRequestException $exception) : callable;


    /**
     * Permet d'attraper et de traiter les exceptions envoyé par les CommandHandler
     * On attend que l'exception soit lancée tout simplement, ou qu'une fonction
     * soit renvoyé en contrepartie
     * ```
     * throw $exception
     * ```
     * or
     * ```
     * return function ($request, $response) use ($exception) {
     *      return $response;
     * }
     * ```
     *
     * @param \Throwable $exception
     * @return callable
     */
    public function getThrowableDecorator(\Throwable $exception) : callable;
}
