<?php

namespace Move\Command\Command;

/**
 * Class SortCommandTrait
 * @package Move\Command\Command
 */
trait SortCommandTrait
{

    /** @var array */
    protected $sortCols = [];

    /**
     * @param string $name
     * @param string $sort
     * @return \Move\Command\Command\SortCommandInterface
     * @throws \InvalidArgumentException
     */
    public function withSortOnCol(string $name, $sort) : SortCommandInterface
    {
        if (!\is_string($sort) || !\in_array(strtolower($sort), ['desc', 'asc'], true)) {
            throw new \InvalidArgumentException('sort must be desc/asc');
        }
        $clone = clone $this;
        $this->sortCols[$name] = strtoupper($sort);
        return $clone;
    }

    /**
     * @param array $sortCols
     * @return SortCommandInterface
     */
    public function withSortCols(array $sortCols) : SortCommandInterface
    {
        $clone = clone $this;
        $clone->sortCols = $sortCols;
        return $clone;
    }

    /**
     * @return array
     */
    public function getSortCols() : array
    {
        return $this->sortCols;
    }

    /**
     * @param string $name
     * @return string|null
     */
    public function getSortOrder(string $name)
    {
        if (isset($this->sortCols[$name])) {
            return strtoupper($this->sortCols[$name]);
        }
        return null;
    }

    /**
     * @param string $name
     * @return bool
     */
    public function isSortDESC(string $name) : bool
    {
        return $this->getSortOrder($name) === 'DESC';
    }

    /**
     * @param string $name
     * @return bool
     */
    public function isSortASC(string $name) : bool
    {
        return $this->getSortOrder($name) === 'ASC';
    }
}
