<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Normalizer\DailymotionNormalizer;
use Move\Embed\Parser\RegexParser;

/**
 * Class Dailymotion
 * @package Embed\AdapterProvider
 */
class Dailymotion extends AbstractAdapterProvider
{

    /**
     * @return Oembed
     */
    public function getAdapter()
    {
        $adapter = new Oembed('http://www.dailymotion.com/services/oembed');
        $adapter->setNormalizer(new DailymotionNormalizer($this->getParser()));
        return $adapter;
    }

    /**
     * @return RegexParser
     */
    public function getParser()
    {
        $pattern = '^(?:https?://)?'; # Optional URL scheme. Either http or https.
        $pattern .= '(?:www\.)?'; #  Optional www subdomain.
        $pattern .= '(?:(?:dailymotion\.com(?:/(?:embed/)?video|/hub))|dai\.ly)'; #  Group host alternatives:
        $pattern .= '/([0-9a-z]+)';
        $pattern .= '(?:[\-_0-9a-zA-Z]+#video=([a-z0-9]+))?'; # video ids
        return new RegexParser(
            '@' . $pattern . '@'
        );
    }
}
