<?php

namespace Move\Newsletter;

use Move\Newsletter\Provider\ProviderInterface;

/**
 * Class NewsletterProviderAwareTrait
 * @package Move\Newsletter
 */
trait ProviderAwareTrait
{

    /** @var  \Move\Newsletter\Provider\ProviderInterface */
    protected $newsletterProvider;

    /**
     * @return \Move\Newsletter\Provider\ProviderInterface
     */
    public function getProvider() : ProviderInterface
    {
        if (!$this->newsletterProvider instanceof ProviderInterface) {
            throw new \UnexpectedValueException('newsletterProvider must be a ProviderAdapterInterface');
        }
        return $this->newsletterProvider;
    }

    /**
     * @param \Move\Newsletter\Provider\ProviderInterface $newsletterProvider
     * @return $this
     */
    public function setProvider(
        ProviderInterface $newsletterProvider
    ) {
        $this->newsletterProvider = $newsletterProvider;
        return $this;
    }
}
