<?php

namespace Move\ObjectMapper;

use POM\Service\CursorPdo;

/**
 * Class ListAllObjectTrait
 * @package Move\ObjectMapper
 */
trait ListAllObjectTrait
{
    use SqlQueryMapperTrait;

    /**
     * @param string $colSort
     * @param string $sort
     * @param int $page
     * @param int $byPage
     * @return \POM\Service\CursorPdo
     */
    protected function fetchAll(
        $colSort = 'modified_at',
        $sort = 'DESC',
        $page = 0,
        $byPage = 20
    ) : CursorPdo {
        return $this->fetchAllCondition([], $colSort, $sort, $page, $byPage);
    }

    /**
     * @param array $condition [WHERE SQL string, bindings []]
     * @param string $colSort
     * @param string $sort
     * @param int $page
     * @param int $byPage
     * @return \POM\Service\CursorPdo
     */
    protected function fetchAllCondition(
        array $condition,
        $colSort = 'modified_at',
        $sort = 'DESC',
        $page = 0,
        $byPage = 20
    ) : CursorPdo {
        $result = $this->fetchCustomQuery($condition, [], [
            $colSort => $sort,
        ], $page, $byPage);
        return $result;
    }
}
