<?php

namespace Move\Specification;

/**
 * Class PatternSpecification
 * @package Move\Specification
 */
class PatternSpecification extends Specification
{
    /**
     * @var string
     */
    private $pattern;

    /**
     * @var string
     */
    private $delimiter;

    /**
     * @var string
     */
    private $opts;

    /**
     * PatternSpecification constructor.
     * @param string $pattern
     * @param string $delimiter
     * @param string $opts
     */
    public function __construct($pattern, $delimiter = '/', $opts = '')
    {
        $this->pattern = $pattern;
        $this->delimiter = $delimiter;
        $this->opts = $opts;
    }

    /**
     * @param mixed $object
     * @return bool
     */
    public function isSatisfiedBy($object) : bool
    {
        if (\is_string($object)) {
            return preg_match(sprintf(
                '%s%s%s%s',
                $this->delimiter,
                $this->pattern,
                $this->delimiter,
                $this->opts
            ), $object) === 1;
        }
        return false;
    }
}
