<?php


namespace Move\Template\Component;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;
use League\Plates\Template\Template;

/**
 * Class AbstractComponent
 * @package Move\Template\Component
 */
abstract class AbstractComponent implements ExtensionInterface
{

    /** @var  string */
    protected $functionName;

    /** @var  Engine */
    protected $engine;

    /** @var  Template */
    public $template;

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        if (!\is_string($this->functionName) || empty($this->functionName)) {
            trigger_error('property functionName is undefined', E_USER_WARNING);
        } else {
            $engine->registerFunction($this->functionName, [$this, 'display']);
        }
        $this->engine = $engine;
    }

    /**
     * @param $template
     * @param array $data
     * @return string
     * @throws \Exception
     * @throws \Throwable
     */
    final public function render($template, array $data = [])
    {
        // check du status
        if (!$this->engine instanceof Engine) {
            throw new \UnexpectedValueException('Component must be register before render it');
        }

        // creation du template
        $template = $this->engine->make($template);

        // creation des données du template
        $this->assignData($template, $data);

        // rendu du template
        return $template->render();
    }

    /**
     * @param string $template
     * @param array $data
     */
    final public function display($template, array $data = [])
    {
        // rendu du template
        echo $this->render($template, $data);
    }

    /**
     * @param Template $template
     * @param array $data
     */
    abstract protected function assignData(Template $template, $data = []);
}
