<?php

namespace Cms\Extension;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;
use Move\Utils\Str;

/**
 * Class StrExtension
 * @package Cms\Extension
 */
class StrExtension implements ExtensionInterface
{

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('substr', [$this, 'runSubStr']);
        $engine->registerFunction('strwrap', [$this, 'runWrap']);
        $engine->registerFunction('ascii', [$this, 'runAscii']);
        $engine->registerFunction('num_format_zerodec', [$this, 'numberFormatDropZeroDecimals']);
    }

    /**
     * @param string $str
     * @param array $replace
     * @param string $delimiter
     * @return string
     */
    public function runAscii($str, $replace = [], $delimiter = '-')
    {
        return Str::toAscii($str, $replace, $delimiter);
    }

    /**
     * @param string $str
     * @param int $limit
     * @param string $completion
     * @return string
     */
    public function runSubStr($str, $limit, $completion = '...')
    {
        $len = mb_strlen($str);
        if ($len < $limit) {
            $completion = '';
        }
        return mb_substr($str, 0, $limit - \strlen($completion)) . $completion;
    }

    /**
     * @param string $str
     * @param int $limit
     * @param string $completion
     * @return string
     */
    public function runWrap($str, $limit, $completion = '...')
    {
        $len = mb_strlen($str);
        if ($len < $limit) {
            $completion = '';
        }
        $limit -= \strlen($completion);
        if (preg_match('/^.{1,' . $limit . '}\s/su', $str, $match)) {
            return $match[0] . $completion;
        }
        return mb_substr($str, 0, $limit) . $completion;
    }

    /**
     * @param mixed $number
     * @param int $decimals
     * @param string $decPoint
     * @param string $thousandsSep
     * @return string
     */
    public function numberFormatDropZeroDecimals($number, $decimals = 2, $decPoint = ',', $thousandsSep = ' ') : string
    {
        return number_format(
            $number,
            floor($number) === round($number, $decimals) ? 0 : $decimals,
            $decPoint,
            $thousandsSep
        );
    }
}
