<?php

namespace Cms\Model\Member;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class MemberAttributeValidator
 * @package Cms\Model\Member\Attribute
 */
class MemberAttributeValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            'member_id' => true,
            'name' => new EnumSpecification(MemberAttributeName::class),
        ]);
        $myFilter->modify('name', function ($name) {
            return (string)$name;
        });

        return $myFilter;
    }
}
