<?php

namespace Move\Http\Strategy;

use Move\Http\Strategy\DataContainer\DataContainer;
use Psr\Http\Message\ResponseInterface;

/**
 * Class ResponseFactory
 * @package Move\Http\Strategy
 */
class ResponseFactory
{
    /**
     * @var mixed
     */
    private $dataset;

    /**
     * @var array
     */
    private $headers;

    /**
     * @var int
     */
    private $statusCode;

    /**
     * ResponseFactory constructor.
     * @param mixed $dataset
     * @param int $statusCode
     * @param array $headers
     */
    public function __construct($dataset, $statusCode = 200, array $headers = [])
    {
        if (!$dataset instanceof DataContainer) {
            $dataset = new DataContainer($dataset);
        }
        $this->dataset = $dataset;
        $this->headers = $headers;
        $this->statusCode = (int)$statusCode;
    }

    /**
     * @param callable $serializer
     * @param ResponseInterface $response
     * @return ResponseInterface
     */
    public function determineResponse(callable $serializer, ResponseInterface $response)
    {
        // ajoute le statusCode
        $response = $response->withStatus($this->statusCode);
        // ajoute les headers
        foreach ($this->headers as $name => $headerValue) {
            $response = $response->withHeader($name, $headerValue);
        }
        // ajoute le body aa la suite de la reponse
        $data = \call_user_func($serializer, $this->dataset, $response);
        if (!\is_string($data)) {
            throw new \UnexpectedValueException('Serializer must return string');
        }
        $response->getBody()->write($data);
        return $response;
    }

    /**
     * @param int $statusCode
     * @return ResponseFactory
     */
    public function setStatusCode($statusCode)
    {
        $this->statusCode = (int)$statusCode;
        return $this;
    }

    /**
     * @param array $headers
     * @return ResponseFactory
     */
    public function mergeHeaders(array $headers)
    {
        $this->headers = array_merge($this->headers, $headers);
        return $this;
    }

    /**
     * @param mixed $dataset
     * @return ResponseFactory
     */
    public function setDataset($dataset)
    {
        if (!$dataset instanceof DataContainer) {
            $dataset = new DataContainer($dataset);
        }
        $this->dataset = $dataset;
        return $this;
    }

    /**
     * @return DataContainer
     */
    public function getDataset()
    {
        return $this->dataset;
    }
}
