<?php

namespace Move\Log;

use Monolog\Formatter\LineFormatter;
use Monolog\Handler\ErrorLogHandler;
use Monolog\Logger;

/**
 * Class ErrorLogHandlerFactory
 * @package Move\Log
 */
class ErrorLogHandlerFactory
{

    /**
     * @param int $logLevel
     * @return \Monolog\Handler\ErrorLogHandler
     */
    public static function create($logLevel = null) : ErrorLogHandler
    {
        // level
        $logLevel = $logLevel ?: Logger::DEBUG;

        // handler
        $handler = new ErrorLogHandler(ErrorLogHandler::OPERATING_SYSTEM, $logLevel);

        // formater
        $logFormatter = new LineFormatter();
        $logFormatter->ignoreEmptyContextAndExtra();
        $logFormatter->includeStacktraces();
        $handler->setFormatter($logFormatter);

        return $handler;
    }
}
