<?php


namespace Move\Template;

use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Plates\Engine;

/**
 * Class EngineProvider
 * @package Move\Template
 */
class EngineProvider extends AbstractServiceProvider
{

    /**
     * @var array
     */
    protected $provides = [
        EngineAwareInterface::class,
        Engine::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        $container = $this->getContainer();

        // creation du moteur de template
        $container
            ->share(Engine::class);

        $container
            ->inflector(EngineAwareInterface::class)
            ->invokeMethod('setEngine', [
                Engine::class,
            ]);
    }
}
