<?php

namespace Move\Command\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchCommandTest
 */
class FetchCommandTest extends TestCase
{

    public function provideId()
    {
        return [
            [1234,],
            [12356,]
        ];
    }

    /**
     * @dataProvider provideId
     * @param int $id
     * @return \Move\Command\Command\FetchCommand
     */
    public function testConstructCommand($id)
    {
        $command = new FetchCommand($id);
        $this->assertEquals($id, $command->getId());

        return $command;
    }

    /**
     * @dataProvider provideId
     * @param $id
     */
    public function testWithId($id)
    {
        $command = new FetchCommand(null);
        $this->assertNull($command->getId());
        $this->assertNotSame($command, $idCmd = $command->withId($id));
        $this->assertEquals($id, $idCmd->getId());
    }
}