<?php

namespace Move\Embed\Parser;

use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class MultiRegexParserTest
 * @package Move\Embed\Parser
 */
class MultiRegexParserTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideMatchString()
    {
        $regex = ['/[a-z]+/', '/[0-9]+/'];
        return [
            [$regex, '123456789', ['123456789']],
            [$regex, 'abc6789', ['abc']],
            [$regex, 'abc123456cba', ['abc','cba']],
            [$regex, '!@#$%^&*1234', ['1234']]
        ];
    }

    /**
     * @covers  MultiRegexParser::__construct
     */
    public function testConstruct()
    {
        $instance = new MultiRegexParser(['/[a-z]+/', '/[0-9]+/']);
        $this->assertInstanceOf(MultiRegexParser::class, $instance);

        $props = Reflection::getValue($instance, 'regexs');
        foreach ($props as $p)
        {
            $this->assertInstanceOf(RegexParser::class, $p);
        }

        $this->assertCount(2, $props);
    }

    /**
     * @dataProvider provideMatchString
     * @covers RegexParser::_invoke
     * @depends testConstruct
     * @param $regex
     * @param $string
     * @param $expected
     */
    public function testMatchString($regex, $string, $expected)
    {
        $instance = new MultiRegexParser($regex);
        $found = [];
        $res = $instance->matchString($string, $found);

        if (empty($expected)) {
            $this->assertFalse($res);
        } else {
            $this->assertTrue($res);
        }

        $this->assertEquals($expected, $found);
    }

    /**
     * @dataProvider provideMatchString
     * @depends testConstruct
     * @param $regex
     * @param $string
     * @param $expected
     */
    public function testInvoke($regex, $string, $expected)
    {
        $instance = new MultiRegexParser($regex);
        $found = [];
        $res = $instance($string, $found);

        if (empty($expected)) {
            $this->assertFalse($res);
        } else {
            $this->assertTrue($res);
        }

        $this->assertEquals($expected, $found);
    }

}
