<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\CampsitePubRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class CampsitePubClient
 * @package Cms\Client\Campsite
 */
class CampsitePubClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite/campsite-pub';

    /**
     * @param array $dataset
     * @return CampsitePubRestfulModel
     */
    public function handleData($dataset = []) : Model\CampsitePubRestfulModel
    {
        return (new CampsitePubRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CampsitePubRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
