<?php

namespace Cms\Client\Campsite\Transformer;

use Cms\Client\Campsite\Model\FeatureRestfulModel;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class FeatureTransformer
 * @package Cms\Client\Campsite\Transformer
 */
class FeatureTransformer extends ObjectTransformer
{

    /**
     * @param DomainObjectInterface|\Cms\Client\Campsite\Model\FeatureRestfulModel $object
     * @return array
     */
    public function transform(DomainObjectInterface $object) : array
    {
        $result = parent::transform($object);
        if (!$object instanceof FeatureRestfulModel) {
            return $result;
        }
        if ($object->field_flag) {
            $result['field_flag'] = $object->field_flag->getArrayCopy();
        }

        // ajoute les code de traduction
        $result['i18n'] = array_map(new ObjectTransformer(), $object->i18n ?: []);

        return $result;
    }
}
