<?php


namespace Cms\Extension\MediaHandler;

use Cms\Client\AssetConfigRelationRestfulModel;

/**
 * Class MediaHandlerRequest
 * @package Cms\Extension\MediaHandler
 */
class MediaHandlerRequest
{

    /** @var AssetConfigRelationRestfulModel */
    private $assetRelationModel;

    /** @var array */
    private $handlerConfig;

    /**
     * MediaHandlerRequest constructor.
     * @param AssetConfigRelationRestfulModel $relationModel
     * @param array $handlerConfig
     */
    public function __construct(AssetConfigRelationRestfulModel $relationModel, $handlerConfig = [])
    {
        $this->assetRelationModel = $relationModel;
        $this->handlerConfig = $handlerConfig;
    }

    /**
     * @return AssetConfigRelationRestfulModel
     */
    public function getAssetRelationModel()
    {
        return $this->assetRelationModel;
    }

    /**
     * @param AssetConfigRelationRestfulModel $assetRelationModel
     * @return MediaHandlerRequest
     */
    public function setAssetRelationModel(AssetConfigRelationRestfulModel $assetRelationModel)
    {
        $this->assetRelationModel = $assetRelationModel;
        return $this;
    }

    /**
     * @return array
     */
    public function getHandlerConfig()
    {
        return $this->handlerConfig;
    }

    /**
     * @param array $handlerConfig
     * @return MediaHandlerRequest
     */
    public function setHandlerConfig(array $handlerConfig)
    {
        $this->handlerConfig = $handlerConfig;
        return $this;
    }
}
