<?php

namespace Cms\Model\Article\LinkResource;

use Cms\LinkResource\LinkResourceType;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class LinkResourceValidator
 * @package Cms\Model\Article\LinkResource
 */
class LinkResourceValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter()
    {
        $filter = new Filter([
            'article_id' => true,
            'link_provider' => true,
            'link_ref' => true,
            'link_type' => new EnumSpecification(LinkResourceType::class),
        ]);

        return $filter;
    }
}
