<?php


namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\MultiRegexParser;

/**
 * Class Twitter
 * @package Move\Embed\AdapterProvider
 */
class Twitter extends AbstractAdapterProvider
{

    /**
     * @return Oembed
     */
    public function getAdapter() : Oembed
    {
        return new Oembed(
            'https://publish.twitter.com/oembed',
            [
                'hide_thread' => true,
                'omit_script' => true,
                'lang' => 'fr',
                'format' => 'json',
            ]
        );
    }

    /**
     * @return MultiRegexParser
     */
    public function getParser() : MultiRegexParser
    {
        return new MultiRegexParser([
            '@^(?:https?:)?//twitter\.com/([^/]+)/status(?:es)?/([0-9]+)@i',
        ]);
    }
}
