<?php

namespace Move\Template\Html\Meta;

/**
 * Class Pagination
 * @package Html\Metadata
 */
class Pagination implements MetaInterface
{

    /** @var null */
    protected $next;

    /** @var null */
    protected $prev;

    /**
     * Link Précédente/Suivante
     * @param null|string $prev
     * @param null|string $next
     */
    public function __construct($prev = null, $next = null)
    {
        $this->prev = $prev ?: null;
        $this->next = $next ?: null;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }

    /**
     * Retourne un identifiant
     */
    public function ident() : string
    {
        return 'link_page';
    }

    /**
     * @{@inheritdoc}
     */
    public function render() : string
    {
        $source = '';
        if (null !== $this->prev) {
            $source .= '<link rel="prev" href="' . $this->prev . '">';
        }
        if (null !== $this->next) {
            $source .= '<link rel="next" href="' . $this->next . '">';
        }
        return $source;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy() : array
    {
        return [
            'prev' => $this->prev,
            'next' => $this->next,
        ];
    }
}
