<?php

namespace Move\Http\Strategy\Handler;

use GuzzleHttp\Psr7\Response;
use Move\Http\Strategy\Serializer\JsonSerializer;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class JsonpHandlerServiceTest
 * @package Move\Http\Strategy\Handler
 */
class JsonpHandlerServiceTest extends TestCase
{
    protected $callbackParam = 'callback';
    /**
     * @return array
     */
    public function provideIsSatisfiedBy()
    {
        return [
            [['callbackFunc' => 'data'], false],
            [[$this->callbackParam => 'data'], true]
        ];
    }

    protected function createInstance()
    {
        // Should use mock...
        $serializer = new JsonSerializer();
        return new JsonpHandlerService($serializer);
    }

    /**
     * @covers JsonpHandlerService::setCallbackParam
     */
    public function testSetCallbackParam()
    {
        $service = $this->createInstance();

        $alteredService = $service->setCallbackParam('callback');
        $this->assertSame($service, $alteredService);
    }

    /**
     * @dataProvider provideIsSatisfiedBy
     * @depends testSetCallbackParam
     * @param $returnValue
     * @param $expected
     */
    public function testIsSatisfiedBy($returnValue, $expected)
    {
        /** @var ServerRequestInterface $requeatInterface */
        $requeatInterface = $this->getMockBuilder(ServerRequestInterface::class)
            ->getMock();

        $requeatInterface->method('getQueryParams')
            ->will($this->returnValue($returnValue));

        $service = $this->createInstance();
        $service->setCallbackParam($this->callbackParam);

        $this->assertEquals($expected, $service->isSatisfiedBy($requeatInterface));
    }

    /**
     * @covers JsonpHandlerService::determineResponse
     */
    public function testDetermineResponse()
    {
        $expectedContentType = 'application/javascript';

        // Should use mock...
        $responseInterface = new Response();
        $service = $this->createInstance();

        $alteredService = $service->determineResponse(
            ['data'=> ['head' => 'body']],
            $responseInterface
        );

        $this->assertInstanceOf(ResponseInterface::class, $alteredService);

        $contentType = $alteredService->getHeader('content-type');

        $this->assertArraySubset([$expectedContentType], $contentType);
    }

}
