<?php

namespace Cms\Client\Contract;

use Cms\Client\AbstractClient;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Contract\Model\ProductConfigRestfulModel;

/**
 * Class ProductConfigClient
 * @package Cms\Client\Contract
 */
class ProductConfigClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'contract/product-config';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * @param array $dataset
     * @return ProductConfigRestfulModel
     */
    public function handleData($dataset = []) : ProductConfigRestfulModel
    {
        return (new ProductConfigRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ProductConfigRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $profil
     * @param string|\Cms\LinkResource\LinkResourceType|null $linkType
     * @param mixed|null $linkRef
     * @param null|string $state
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Contract\Model\ProductConfigRestfulModel[]
     */
    public function getIndexForProductProfil(
        $profil,
        $linkType = null,
        $linkRef = null,
        $state = null
    ) {
        $builder = $this->getBuilder()
            ->setFilter('product_profil', $profil);
        if ($linkType) {
            $builder
                ->setFilter('link_type', $linkType);
        }
        if ($linkRef) {
            $builder
                ->setFilter('link_ref', $linkRef);
        }
        if ($state) {
            $builder
                ->setFilter('state', $state);
        }
        return $builder->getIndex(-1);
    }

    /**
     * @param int $productId
     * @param string|\Cms\LinkResource\LinkResourceType|null $linkType
     * @param mixed|null $linkRef
     * @param null|string $state
     * @param bool $expendSearch
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Contract\Model\ProductConfigRestfulModel[]
     * @throws \InvalidArgumentException
     */
    public function getIndexForProduct(
        int $productId,
        $linkType = null,
        $linkRef = null,
        $state = null,
        bool $expendSearch = false
    ) {
        $builder = $this->getBuilder()
            ->setFilter('product_id', $productId)
            ->setFilter('expend_search', $expendSearch);
        // si un des deux est rempli l'autre doit être rempli aussi
        if (!$linkRef xor !$linkType) {
            throw new \InvalidArgumentException('link_ref & link_type must be set');
        }
        if ($linkRef && $linkType) {
            $builder
                ->setFilter('link_ref', $linkRef)
                ->setFilter('link_type', $linkType);
        }
        if ($state) {
            $builder
                ->setFilter('state', $state);
        }
        return $builder->getIndex(-1);
    }
}
