<?php

namespace Cms\Extension;

use Cms\Model\I18nHelper;
use function Cms\Utils\vksprintf;
use League\Plates\Engine;
use Move\Template\Extensions\Translate;

/**
 * Class TranslateExtension
 * @package Cms\Extension
 */
class TranslateExtension extends Translate
{

    /** @var  string */
    public static $LANGUAGE;


    /**
     * @param \League\Plates\Engine $engine
     */
    public function register(Engine $engine)
    {
        parent::register($engine);
        $engine->registerFunction('i18n_label', [$this, 'runTranslateLabel']);
    }

    /**
     * @param mixed $object
     * @param string|null $field
     * @param string|null $default
     * @param string|null $lang
     * @return null|string
     * @throws \InvalidArgumentException
     */
    public function runTranslateLabel(
        $object,
        string $field = null,
        string $default = null,
        string $lang = null
    ) {
        $defaultLang = static::$LANGUAGE ?: null;
        $lang = $lang ?: $defaultLang;
        return I18nHelper::translateObject($object, $field, $default, $lang);
    }

    /**
     * @param string $message
     * @param array $args
     * @return string
     */
    public function runGettext($message, array $args = []) : string
    {
        return vksprintf(gettext($message), $args);
    }
}
