<?php


namespace Cms\Model\Contract;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EmptySpecification;
use Move\Specification\EnumSpecification;

/**
 * Class ContractValidator
 * @package Cms\Model\Contract
 */
class ContractValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter() : Filter
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            //'link_provider' => true,
            //'link_type' => new EnumSpecification(LinkResourceType::class),
            //'link_ref' => true,
            'state' => (new EmptySpecification())->orSpec(
                new EnumSpecification(ContractState::class)
            ),
        ]);
        return $myFilter;
    }
}
