<?php

namespace Cms\Search\Mapping;

use Move\Search\Analyzer\GeoFrenchAnalyzer;
use Move\Search\Analyzer\GeoFrenchSearchAnalyzer;
use Move\Search\Mapping\ElasticMappingProperty;
use Move\Search\Mapping\KeywordMapping;
use Move\Search\Mapping\ObjectMapping;
use Move\Search\Mapping\TextMapping;

/**
 * Trait GeoAdminPropertiesTrait
 * @package Cms\Search\Mapping
 */
trait GeoAdminPropertiesTrait
{

    /**
     * @return array
     */
    private function getGeoAdminProperties() : array
    {
        $properties = [
            new ElasticMappingProperty('id', 'long'),
            new ElasticMappingProperty('parent_id', 'long', false),
            new ElasticMappingProperty('admin_level', 'long'),
            (new KeywordMapping('admin_code_simple')),
            (new KeywordMapping('admin_code_concat')),
            (new KeywordMapping('admin_code_parent', false)),
            (new KeywordMapping('admin_country_code')),
            (new KeywordMapping('admin_slug')),
            (new TextMapping('admin_name'))->withAnalyzer(
                new GeoFrenchAnalyzer(),
                new GeoFrenchSearchAnalyzer()
            ),
            (new ObjectMapping('admin_name_i18n', [ // autre langue
                new ElasticMappingProperty('id', 'long'),
                (new KeywordMapping('language')),
                (new KeywordMapping('admin_slug')),
                (new TextMapping('admin_name'))->withAnalyzer(
                    new GeoFrenchAnalyzer(),
                    new GeoFrenchSearchAnalyzer()
                ),
            ]))->isNested(true),
            (new KeywordMapping('country_code')),
        ];

        return $properties;
    }
}
