<?php

namespace Move\Specification;

/**
 * Class Specification
 * @package Move\Specification
 */
abstract class Specification implements SpecificationInterface
{
    /**
     * @return NotSpecification
     */
    public function notSpec() : NotSpecification
    {
        return new NotSpecification($this);
    }

    /**
     * @param \Move\Specification\SpecificationInterface $specification
     * @return \Move\Specification\AndSpecification
     */
    public function andSpec(SpecificationInterface $specification) : AndSpecification
    {
        return new AndSpecification($this, $specification);
    }

    /**
     * @param \Move\Specification\SpecificationInterface $specification
     * @return \Move\Specification\OrSpecification
     */
    public function orSpec(SpecificationInterface $specification) : OrSpecification
    {
        return new OrSpecification($this, $specification);
    }

    /**
     * @param mixed $object
     * @return bool
     */
    public function __invoke($object) : bool
    {
        return $this->isSatisfiedBy($object);
    }
}
