<?php


namespace Cms\Cache;

use MatthiasMullie\Scrapbook\Adapters\Apc;
use MatthiasMullie\Scrapbook\Adapters\MemoryStore;
use MatthiasMullie\Scrapbook\KeyValueStore;
use MatthiasMullie\Scrapbook\Psr16\SimpleCache;
use MatthiasMullie\Scrapbook\Psr6\Pool;
use Psr\Cache\CacheItemPoolInterface;
use Psr\SimpleCache\CacheInterface;

/**
 * Class CacheFactory
 * @package Cms\Cache
 */
class CacheFactory
{

    /** @var MemoryStore */
    private static $memoryStore;

    /**
     * @return \MatthiasMullie\Scrapbook\Adapters\MemoryStore
     */
    private static function getMemoryKVStore() : MemoryStore
    {
        return static::$memoryStore ?: (static::$memoryStore = new MemoryStore());
    }

    /**
     * @return \MatthiasMullie\Scrapbook\KeyValueStore
     */
    private static function createLocalKVStore() : KeyValueStore
    {
        if (PHP_SAPI !== 'cli') {
            try {
                $cacheStore = new Apc();
            } catch (\Exception $e) {
                trigger_error($e->getMessage() . ' fallback to MemoryStore', E_USER_WARNING);
                $cacheStore = static::getMemoryKVStore();
            }
        } else {
            $cacheStore = static::getMemoryKVStore();
        }
        return $cacheStore;
    }

    /**
     * @return \Psr\Cache\CacheItemPoolInterface
     */
    public static function createLocalPool() : CacheItemPoolInterface
    {
        $cacheStore = static::createLocalKVStore();
        return new Pool($cacheStore);
    }

    /**
     * @return \Psr\SimpleCache\CacheInterface
     */
    public static function createLocalSimpleCache() : CacheInterface
    {
        $cacheStore = static::createLocalKVStore();
        return new SimpleCache($cacheStore);
    }
}
