<?php


namespace Cms\Client\Command\Contract;

use Cms\Cache\CacheHelperTrait;
use Cms\Client\Command\CommandExceptionHandleTrait;
use Cms\Client\Command\Contract\Command\FetchAllContractByFilterCommand;
use Cms\Client\Contract\ContractClient;
use Move\Http\Client\Exception\HttpRequestException;

/**
 * Class ContractCommandHandler
 * @package Cms\Client\Command\Contract
 */
class ContractCommandHandler
{
    use CacheHelperTrait;
    use CommandExceptionHandleTrait;

    /** @var ContractClient */
    private $contractClient;

    /**
     * ContractCommandHandler constructor.
     * @param ContractClient $contractClient
     */
    public function __construct(ContractClient $contractClient)
    {
        $this->contractClient = $contractClient;
    }

    /**
     * @param FetchAllContractByFilterCommand $command
     * @return array
     */
    public function handlefetchAllContractByFilter(FetchAllContractByFilterCommand $command)
    {
        $scopeId = $command->getScopeId();
        $beginAt = $command->getBeginAt();
        $endAt = $command->getEndAt();

        try {
            $contracts = $this->contractClient->fetchItemByInterval($scopeId, $beginAt, $endAt);
        } catch (HttpRequestException $e) {
            $this->logHttpRequestException('ContractCmdHd_FetchAllContract', $e);
        } finally {
            if (!isset($contracts)) {
                $contracts = null;
            }
        }
        return $contracts ?: [];
    }
}
