<?php


namespace Cms\Client\Command\Geodata\Command;

/**
 * Class FetchAllAdminByFilterCommand
 * @package Cms\Client\Command\Geodata\Command
 */
class FetchAllAdminByFilterCommand
{

    /** @var string */
    private $countryCode;

    /** @var string|null */
    private $adminCode;

    /** @var int|null */
    private $adminLevel;

    /** @var string|null */
    private $adminSlug;


    /**
     * FetchAllAdminByFilterCommand constructor.
     * @param string|null $countryCode
     * @param string|null $adminCode
     * @param int|null $adminLevel
     */
    public function __construct(string $countryCode = null, $adminCode = null, $adminLevel = null)
    {
        $this->countryCode = $countryCode;
        $this->adminCode = $adminCode;
        $this->adminLevel = $adminLevel;
    }

    /**
     * @return string
     */
    public function getCountryCode() : ?string
    {
        return $this->countryCode;
    }

    /**
     * @param string|null $countryCode
     * @return $this
     */
    public function setCountryCode(?string $countryCode)
    {
        $this->countryCode = $countryCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAdminCode()
    {
        return $this->adminCode;
    }

    /**
     * @param string|null $adminCode
     * @return $this
     */
    public function setAdminCode($adminCode)
    {
        $this->adminCode = $adminCode;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getAdminLevel()
    {
        return $this->adminLevel;
    }

    /**
     * @param int|null $adminLevel
     * @return $this
     */
    public function setAdminLevel($adminLevel)
    {
        $this->adminLevel = $adminLevel;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getAdminSlug()
    {
        return $this->adminSlug;
    }

    /**
     * @param null|string $adminSlug
     * @return $this
     */
    public function setAdminSlug($adminSlug)
    {
        $this->adminSlug = $adminSlug;
        return $this;
    }
}
