<?php

namespace Cms\LinkResource;

use POM\DomainObjectAbstract;

/**
 * Class LinkResourcePrefsModel
 * @package Cms\LinkResource
 * @property string $identifier
 */
class LinkResourcePrefsModel extends DomainObjectAbstract implements \JsonSerializable
{

    /** @var  string */
    protected $identifier;

    /**
     * Specify data which should be serialized to JSON
     * @link http://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return $this->getArrayCopy();
    }
}
