<?php


namespace Cms\LinkResource\Provider;

/**
 * Class AbstractDelegateTypeAdapter
 * @package Cms\LinkResource\Provider
 */
abstract class AbstractDelegateTypeAdapter implements DelegateTypeAdapterInterface
{

    /** @var  array */
    protected $types = [];

    /**
     * @inheritdoc
     * @throws \UnexpectedValueException
     */
    public function getTypes() : array
    {
        if (empty($this->types)) {
            return [];
        }
        if (!\is_array($this->types)) {
            throw new \UnexpectedValueException('types must be an array');
        }
        return $this->types;
    }
}
