<?php

namespace Move\Template\Html\Meta;

use Move\Template\Html\RenderByTagStrategy;
use Move\Template\Html\RenderStrategyInterface;
use Move\Utils\TaggedItemCollection;

/**
 * Class MetaCollection
 * @package Move\Template\Html\Meta
 */
class MetaCollection extends TaggedItemCollection
{

    /**
     * @var RenderStrategyInterface
     */
    private $strategy;

    /**
     * @param array $banishTags
     * @param RenderStrategyInterface|null $strategy
     */
    public function __construct(array $banishTags = [], RenderStrategyInterface $strategy = null)
    {
        parent::__construct($banishTags);
        $this->strategy = $strategy ?: new RenderByTagStrategy();
    }

    /**
     * Ajoute plusieurs metas
     * @param MetaInterface[] $metas
     * @param array $tags
     * @param bool $unique
     * @param bool $prepend
     * @return $this
     */
    public function addMulti(array $metas = [], array $tags = [], $unique = false, $prepend = false)
    {
        foreach ($metas as $meta) {
            $this->add($meta, $tags, true, $prepend);
        }
        return $this;
    }

    /**
     * Ajoute un nouveau meta à la liste
     * @param MetaInterface $meta
     * @param array $tags
     * @param bool $unique
     * @param bool $prepend
     * @return \Move\Template\Html\Meta\MetaCollection|\Move\Utils\TaggedItemCollection
     * @throws \InvalidArgumentException
     */
    public function add($meta, array $tags = [], $unique = false, $prepend = false)
    {
        if (!$meta instanceof MetaInterface) {
            throw new \InvalidArgumentException('only MetaInterface can be added');
        }

        // insert des provider de meta
        if ($meta instanceof MetaProviderInterface) {
            $meta->register($this);
            return $this;
        }

        // on force l'unicité sur le premier tag
        array_unshift($tags, $meta->ident());
        $this->setUniqueOnFirstTag();

        return parent::add($meta, $tags, true, $prepend);
    }

    /**
     * Renvoi la liste des metas dont TOUS les tags sont $tags
     * @param array $tags
     * @return MetaInterface[]
     */
    public function getByTags(array $tags)
    {
        return parent::getByTags($tags);
    }

    /**
     * Renvoi la liste des metas dont un tag est $tag
     * @param string $tag
     * @return MetaInterface[]
     */
    public function getByTag($tag)
    {
        return parent::getByTag($tag);
    }

    /**
     * @return MetaInterface[]
     */
    public function getAll()
    {
        return parent::getAll();
    }

    /**
     * Effectue un rendu de tous les assets via la strategy
     * @param string|array $tags
     * @return string
     */
    public function render($tags = [])
    {
        if (!\is_array($tags)) {
            $tags = [$tags];
        }
        return $this->strategy->render($this, $tags);
    }
}
