<?php


namespace Cms\Bundle\Helper;

use Cms\Model\Campsite\Feature\FeatureCode;

/**
 * Class CampsiteHelper
 * @package Cms\Bundle\Helper
 */
class CampsiteHelper
{

    /**
     * @param array $features
     * @return array
     */
    public static function getCampsiteClassement(array $features) : array
    {
        // récuperation du classement du campings
        $nbetoile = 0;
        $isPRL = $isFFCC = false;
        foreach ($features as $feature) {
            if (!isset($feature['feature_code'])) {
                continue;
            }
            if ($feature['feature_code'] === FeatureCode::PRL
                && !empty($feature['value'])
            ) {
                $isPRL = true;
            }
            if ($feature['feature_code'] === FeatureCode::CLASSEMENT
                && !empty($feature['value'])
            ) {
                $nbetoile = substr_count($feature['value'], '*');
            }
            if ($feature['feature_code'] === FeatureCode::FFCC) {
                $isFFCC = !empty($feature['value']);
            }
        }
        return [$nbetoile, $isPRL, $isFFCC];
    }
}
