<?php


namespace Cms\Client\Command\Article;

/**
 * Class CategoryFilterAwareTrait
 * @package Cms\Client\Command\Article
 */
trait CategoryFilterAwareTrait
{

    /**
     * @var int|array
     */
    protected $categoryIds;

    /**
     * @var int
     */
    protected $parentCategoryId;

    /**
     * @return int|array
     */
    public function getCategoryIds()
    {
        return $this->categoryIds;
    }

    /**
     * @param int|array $categoryId
     * @return $this
     */
    public function setCategoryIds($categoryId)
    {
        $this->categoryIds = $categoryId;
        return $this;
    }

    /**
     * @return int
     */
    public function getParentCategoryId()
    {
        return $this->parentCategoryId;
    }

    /**
     * @param int|array $parentCategoryId
     * @return $this
     */
    public function setParentCategoryId($parentCategoryId)
    {
        $this->parentCategoryId = $parentCategoryId;
        return $this;
    }
}
