<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\ScopeClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class ScopeProvider
 * @package Cms\Client\Service
 */
class ScopeProvider extends AbstractServiceProvider
{
    /** @var array */
    protected $provides = [
        ScopeClient::class,
        ScopeService::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        //add client
        $this->container->add(ScopeClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        //add service
        $this->container->add(ScopeService::class)
            ->withArguments([
                ScopeClient::class,
            ]);
    }
}
