<?php


namespace Cms\Client\Service;

/**
 * Trait ScopeServiceAwareTrait
 * @package Cms\Client\Service
 */
trait ScopeServiceAwareTrait
{

    /** @var  \Cms\Client\Service\ScopeService */
    protected $scopeService;

    /**
     * @param \Cms\Client\Service\ScopeService $scopeService
     * @return $this
     */
    public function setScopeService(ScopeService $scopeService)
    {
        $this->scopeService = $scopeService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\ScopeService
     * @throws \DomainException
     */
    public function getScopeService() : ScopeService
    {
        if (!$this->scopeService instanceof ScopeService) {
            throw new \DomainException('scopeService is not a ScopeService instance');
        }
        return $this->scopeService;
    }
}
