<?php

namespace Move\Http\Strategy\Serializer;

use League\Fractal\Manager;
use League\Fractal\Resource\Item;
use League\Fractal\Resource\ResourceInterface;
use League\Fractal\Serializer\ArraySerializer;
use Psr\Http\Message\ResponseInterface;

/**
 * Class FractalAdapterSerializer
 * @package Move\Http\Strategy\Serializer
 */
class FractalAdapterSerializer implements SerializerInterface
{

    /**
     * @var Manager
     */
    private $manager;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * JsonResponseHandler constructor.
     * @param Manager $manager
     * @param SerializerInterface $serializer
     */
    public function __construct(Manager $manager, SerializerInterface $serializer)
    {
        $this->manager = $manager;
        $this->serializer = $serializer;
    }

    /**
     * @inheritdoc
     * @throws \UnexpectedValueException
     */
    public function serialize($dataset, ResponseInterface $response)
    {
        // cas d'une resource
        if ($dataset instanceof ResourceInterface) {
            // TODO: cas particulier a supprimer
            if ($dataset instanceof Item && $dataset->getResourceKey() === 'error') {
                $this->manager->setSerializer(new ArraySerializer());
            }
            $dataset = $this->manager->createData($dataset)->toArray();
        }

        // cas impossible
        if (!isset($dataset) || !\is_array($dataset)) {
            throw new \UnexpectedValueException('response cannot be make from dataset ' . gettype($dataset));
        }

        // convertion
        $data = $this->serializer->serialize($dataset ?: [], $response);

        return $data;
    }

    /**
     * @inheritdoc
     * @throws \UnexpectedValueException
     */
    public function __invoke($dataset, ResponseInterface $response)
    {
        return $this->serialize($dataset, $response);
    }
}
