<?php

namespace Move\Specification;

/**
 * Class ArrayOfSpecification
 * @package Move\Specification
 */
class ArrayOfSpecification extends Specification
{

    /** @var \Move\Specification\Specification */
    private $spec;

    /**
     * ArrayOfSpecification constructor.
     * @param \Move\Specification\Specification $spec
     */
    public function __construct(Specification $spec)
    {
        $this->spec = $spec;
    }

    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($object) : bool
    {
        return \is_array($object) && array_sum(array_map(function ($item) {
            return $this->spec->isSatisfiedBy($item) ? 0 : 1;
        }, $object)) === 0;
    }
}
