<?php

namespace Move\Command\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class UpdateCommandTest
 */
class UpdateCommandTest extends TestCase
{

    /**
     * @return array
     */
    public function provideInstall()
    {
        return [
            [
                1234,
                ['title' => "Title de l'article", 'has_data' => true, 'abstract' => null],
            ],
            [
                12356,
                ['title' => "Title de l'article", 'has_data' => true, 'abstract' => null],
            ],
        ];
    }

    /**
     * @return array
     */
    public function provideDataset()
    {
        return [
            [
                ['title' => "Title de l'article", 'has_data' => true, 'abstract' => null],
            ],
            [
                ['title' => "Title de l'article", 'has_data' => true, 'abstract' => null],
            ]
        ];
    }

    public function provideDryRun()
    {
        return [
            'with DryRun' => [true,],
            'without DryRun' => [false,]
        ];
    }

    public function provideId()
    {
        return [
            [1234,],
            [12356,]
        ];
    }

    /**
     * @dataProvider provideInstall
     * @param int $id
     * @param array $dataset
     * @return \Move\Command\Command\UpdateCommand
     */
    public function testConstructCommand($id, array $dataset)
    {
        $command = new UpdateCommand($id, $dataset);
        $this->assertEquals($dataset, $command->getDataset());
        $this->assertEquals($id, $command->getId());
        $this->assertFalse($command->isDryRun());

        return $command;
    }

    /**
     * @depends testConstructCommand
     * @dataProvider provideDryRun
     * @param bool $isDryRun
     */
    public function testWithDryRun(bool $isDryRun)
    {
        $command = new UpdateCommand(null, []);
        $this->assertFalse($command->isDryRun());
        $this->assertNotSame($command, $dryRunCmd = $command->withDryRun($isDryRun));
        $this->assertEquals($isDryRun, $dryRunCmd->isDryRun());
    }

    /**
     * @depends testConstructCommand
     * @dataProvider provideDataset
     * @param $dataset
     */
    public function testWithDataset($dataset)
    {
        $command = new UpdateCommand(null, []);
        $this->assertEmpty($command->getDataset());
        $this->assertNotSame($command, $dataCmd = $command->withDataset($dataset));
        $this->assertEquals($dataset, $dataCmd->getDataset());
    }

    /**
     * @depends testConstructCommand
     * @dataProvider provideId
     * @param $id
     */
    public function testWithId($id)
    {
        $command = new UpdateCommand(null, []);
        $this->assertNull($command->getId());
        $this->assertNotSame($command, $idCmd = $command->withId($id));
        $this->assertEquals($id, $idCmd->getId());
    }
}