<?php


namespace Cms\Client\Command;

use Move\Command\CommandBusInterface;
use Move\Command\Exception\CommandException;
use Move\Command\Exception\NotFoundException;

/**
 * Class CommandExecutorHelper
 * @package Cms\Client\Command
 */
class CommandExecutorHelper
{

    /**
     * @param \Move\Command\CommandBusInterface $commandBus
     * @param mixed $command
     * @param \Cms\Client\Command\ExceptionDecoratorInterface|null $decorator
     * @return mixed
     * @throws \Move\Command\Exception\CommandException
     * @throws \Move\Command\Exception\NotFoundException
     */
    public static function handleCmd(
        CommandBusInterface $commandBus,
        $command,
        ExceptionDecoratorInterface $decorator = null
    ) {
        try {
            $result = $commandBus->handle($command);
        } catch (NotFoundException $e) {
            if ($decorator !== null) {
                \call_user_func($decorator->getNotFoundDecorator($e));
            }
            throw $e;
        } catch (CommandException $e) {
            if ($decorator !== null) {
                \call_user_func($decorator->getThrowableDecorator($e));
            }
            throw $e;
        }
        return $result;
    }
}
