<?php


namespace Cms\LinkResource;

use Cms\Client\AddressBook\Model\AddressRestfulModel;

/**
 * Trait LinkResourceHandlerAwareTrait
 * @package Cms\LinkResource
 */
trait LinkResourceHandlerAwareTrait
{

    /** @var  \Cms\LinkResource\LinkResourceHandler */
    protected $resourceHandler;

    /**
     * @param \Cms\LinkResource\LinkResourceHandler $resourceHandler
     * @return $this
     */
    public function setLinkResourceHandler(LinkResourceHandler $resourceHandler)
    {
        $this->resourceHandler = $resourceHandler;
        return $this;
    }

    /**
     * @return \Cms\LinkResource\LinkResourceHandler
     * @throws \DomainException
     */
    public function getLinkResourceHandler() : LinkResourceHandler
    {
        if (!$this->resourceHandler instanceof LinkResourceHandler) {
            throw new \DomainException('resourceHandler is not a LinkResourceHandler instance');
        }
        return $this->resourceHandler;
    }

    /**
     * @param \Cms\LinkResource\FlattenResourcesAwareInterface $resourcesAware
     * @param string $identifier
     * @return \Cms\Client\AddressBook\Model\AddressRestfulModel|null
     * @throws \UnexpectedValueException
     */
    protected function getFirstObjectAddress(
        FlattenResourcesAwareInterface $resourcesAware,
        $identifier
    ) {
        /** @noinspection ExceptionsAnnotatingAndHandlingInspection */
        $resources = $resourcesAware->getResourceByType(
            LinkResourceType::ADDRESS_ADDRESS,
            'identifier',
            $identifier
        );
        if (!$resources) {
            return null;
        }
        /** @noinspection ExceptionsAnnotatingAndHandlingInspection */
        $addressModel = $this
            ->getLinkResourceHandler()
            ->getDataByModel($resources[0]);
        if ($addressModel instanceof AddressRestfulModel) {
            return $addressModel;
        }
        throw new \UnexpectedValueException(
            'addressModel cannot be retrieve from resource handler'
        );
    }
}
