<?php


namespace Cms\Mail;

use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;

/**
 * Class Sender
 * @package Cms\Mail
 */
class Sender implements LoggerAwareInterface
{
    use LoggerAwareTrait;

    /** @var SenderAdapterInterface */
    private $senderAdapter;

    /**
     * Sender constructor.
     * @param SenderAdapterInterface $senderAdapter
     */
    public function __construct(SenderAdapterInterface $senderAdapter)
    {
        $this->senderAdapter = $senderAdapter;
        $this->logger = new NullLogger();
    }

    /**
     * @return SenderAdapterInterface
     */
    public function getSenderAdapter() : SenderAdapterInterface
    {
        return $this->senderAdapter;
    }
}
